
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Online earning site" name="author">
    <meta name="keywords" content="">

      <meta name="csrf-token" content="{{ csrf_token() }}"/>
    <title>{{ website_title() }}</title>
    <link rel="icon" href="{{ URL::to(website_favicon()) }}" type="image/x-icon" />
    @include('user.layouts.partials.styles')
    @yield('css')

    {{-- For Tostr Alert --}}
    <link href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.0.0-
    alpha/css/bootstrap.css" rel="stylesheet">

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

    <link rel="stylesheet" type="text/css"
        href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
     
    <style>
        .mh-200{
            min-height: 200px
        }
        
        .mh-300{
            min-height: 300px
        }
        .body-top-section {
            background-color: #4285f4;
        }
    </style>
   
    @foreach(head_scripts() as $head_script)
        @if($head_script->script)
            {!! $head_script->script !!}
        @endif
    @endforeach
</head>


<body data-sidebar="dark">

    <div id="layout-wrapper">
        @include('user.layouts.partials.header')

        @include('user.layouts.partials.sidebar')

        <div class="main-content">
            <div class="page-content" style="background-color: #F8F9FE">

                <div class="body-top-section">
                    <div class="mb-2 d-flex justify-content-center gap-2">
                        <button class="btn btn-sm text-white mbl-btn mbl-mt" type="button" style="background-color: #000066; width: 140px;">
                            Earning: ${{ number_format(Auth::user()->earning_balance, 3) }}
                        </button>
                    
                        <button class="btn btn-sm text-white mbl-btn mbl-mt mr-3" type="button" style="background-color: #008000; width: 142px; height: 30px;">
                            Deposit: ${{ number_format(Auth::user()->deposit_balance, 3) }}
                        </button>
                    </div>
                    
                    
                    @include('user.layouts.partials.headline-and-ads')
                </div>
    
                @if(google_head_ad())
                    <div class="container-fluid mh-200">
                        <div class="row justify-content-center">
                            <div class="col-12">
                                {!! google_head_ad()->code !!}
                            </div>
                        </div>
                    </div>
                @endif
                <div class="container-fluid">
                    @yield('user-content')
                </div>
                @include('user.layouts.partials.footer')
            </div>
        </div>

        @include('user.layouts.partials.notification-modal')
    </div>

    @include('user.layouts.partials.scripts')
    @yield('js')


    {{-- For Tostr Alert --}}
    <script>
        @if(Session::has('message'))
            toastr.options =
            {
                "closeButton" : true,
                "progressBar" : true
            }
            toastr.success("{{ session('message') }}");
        @endif

        @if(Session::has('error'))
            toastr.options =
            {
                "closeButton" : true,
                "progressBar" : true
            }
            toastr.error("{{ session('error') }}");
        @endif

        @if(Session::has('info'))
            toastr.options =
            {
                "closeButton" : true,
                "progressBar" : true
        }
            toastr.info("{{ session('info') }}");
        @endif

        @if(Session::has('warning'))
            toastr.options =
            {
                "closeButton" : true,
                "progressBar" : true
            }
            toastr.warning("{{ session('warning') }}");
        @endif
    </script>

    <script>
        @if(count($errors) > 0)
            @foreach($errors->all() as $error)
                toastr.error("{{ $error }}");
            @endforeach
        @endif
        
        function showNotificationModal(){
            $('#notification_modal').modal('show');
        }
        
        function closeNotificationModal(){
            $('#notification_modal').modal('hide');
        }
    
       $(document).mouseup(function(e) {
            var sidebar = $("#vertical_menu");
    
            if (!sidebar.is(e.target) && sidebar.has(e.target).length === 0) {
                $("body").removeClass("sidebar-enable");
            }
        });
    </script>
</body>
</html>
